﻿using System;
using System.IO;
using Microsoft.Win32;

public static class RFIDDriverHelpers
{
    public static string GetRFIDModuleReference()
    {
        string result = string.Empty;

        using (RegistryKey key = Registry.LocalMachine.OpenSubKey("SOFTWARE").OpenSubKey("PsionTeklogix").OpenSubKey("RFIDDevice"))
        {
            result = (string) key.GetValue("Module");
        }

        return result;
    }

    public static string GetRFIDDriverVersion()
    {
        string result = string.Empty;

        using (RegistryKey key = Registry.LocalMachine.OpenSubKey("SOFTWARE").OpenSubKey("PsionTeklogix").OpenSubKey("RFIDDevice"))
        {
            result = (string)key.GetValue("DllVersion");
        }

        return result;
    }
}

